//
//  MainViewController.h
//  iOS SDK Sample
//
//  Created by NEI アプリGr on 2013/06/11.
//  Copyright (c) 2013年 Nippon Primex Inc. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <NPrinterLib/NPrinterLib.h>

#import "SubForm01ViewController.h"
#import "SubForm02ViewController.h"
#import "SubForm03ViewController.h"
#import "SubForm04ViewController.h"
#import "SubForm05ViewController.h"
#import "SubForm06ViewController.h"
#import "SubForm07ViewController.h"

@interface MainViewController : UIViewController <UITextFieldDelegate>
{
    NPrinterLib* mObjLib;        // comment:NPI SDK Class declaration
    
    IBOutlet UILabel *lblReturnCode;
    IBOutlet UITextField *txtPrinterName;
    
    IBOutlet UIButton *btnInformation;

    IBOutlet UIButton *btnOpenPrt;
    IBOutlet UIButton *btnClosePrt;
    IBOutlet UIButton *btnAllClosePrt;
    IBOutlet UIButton *btnPrint;
    IBOutlet UIButton *btnStatus;
    IBOutlet UIButton *btnReset;
    IBOutlet UIButton *btnBarcode;
    IBOutlet UIButton *btnLogCheck;
    IBOutlet UIButton *btnVersionCheck;
    IBOutlet UIButton *btnReceiptTest;
    IBOutlet UIButton *btnTicketTest;
    IBOutlet UIButton *btnRepeat;
    IBOutlet UIButton *btnBack;
    IBOutlet UIScrollView *mSclView;
    
    
    
    UITextField* _activeField;
    

}

@property(nonatomic) NPrinterLib* objLib;
@property(nonatomic) UIScrollView* sclView;


- (IBAction)pushBtnNOpenPrinter:(UIButton *)sender;
- (IBAction)pushBtnNClosePrinter:(UIButton *)sender;
- (IBAction)pushBtnNClosePrinters:(UIButton *)sender;

- (IBAction)pushBtnVersionCheck:(UIButton *)sender;

- (IBAction)pushBtnReceiptTest:(UIButton *)sender;
- (IBAction)pushBtnTicketTest:(UIButton *)sender;
- (IBAction)pushBtnBack:(UIButton *)sender;

@end
